/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.structure;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CreativeStructureHandler
extends AbstractStructureHandler {
    public boolean fancyPlacement;

    public CreativeStructureHandler(Level world, BlockPos pos, String structureName, PlacementSettings settings, boolean fancyPlacement) {
        super(world, pos, structureName, settings);
        this.fancyPlacement = fancyPlacement;
    }

    public CreativeStructureHandler(Level world, BlockPos pos, Blueprint blueprint, PlacementSettings settings, boolean fancyPlacement) {
        super(world, pos, blueprint, settings);
        this.fancyPlacement = fancyPlacement;
    }

    @Override
    @Nullable
    public IItemHandler getInventory() {
        return null;
    }

    @Override
    public void triggerSuccess(BlockPos pos, List<ItemStack> requiredRes, boolean placement) {
    }

    @Override
    public void triggerEntitySuccess(BlockPos pos, List<ItemStack> requiredRes, boolean placement) {
    }

    @Override
    public int getMaxBlocksCheckedPerCall() {
        return (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get();
    }

    @Override
    public boolean isStackFree(@Nullable ItemStack stack) {
        return true;
    }

    @Override
    public boolean allowReplace() {
        return true;
    }

    @Override
    public ItemStack getHeldItem() {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean replaceWithSolidBlock(BlockState blockState) {
        return !blockState.m_60767_().m_76333_();
    }

    @Override
    public boolean fancyPlacement() {
        return this.fancyPlacement;
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    @Override
    public int getStepsPerCall() {
        return (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get();
    }

    @Override
    public boolean shouldBlocksBeConsideredEqual(BlockState state, BlockState state1) {
        return false;
    }

    @Override
    public boolean hasRequiredItems(List<ItemStack> requiredItems) {
        return true;
    }

    @Override
    public void prePlacementLogic(BlockPos worldPos, BlockState blockState, List<ItemStack> requiredItems) {
    }

    @Override
    public BlockState getSolidBlockForPos(BlockPos worldPos) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.getWorld(), worldPos, null);
    }

    @Override
    public BlockState getSolidBlockForPos(BlockPos worldPos, BlockState virtualBlockAbove) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.getWorld(), worldPos, virtualBlockAbove);
    }
}

